import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific resource-type container UIDs.
 */
export interface IResourceTypeUids {
    /**
     * Returns the default domain resource-type container UID
     * @param domain id domain
     * @returns default domain resource-type container UID
     */
    identifier(domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class ResourceTypeUidsClient extends ApiEndPoint implements IResourceTypeUids {
    constructor(apiKey: string, base?: string);
    identifier(domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
