import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './NoteUidsClient.json';

export class NoteUidsClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/notes/uids');
    }
    async getDefaultUserNotes(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_default_notes';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUserCreatedNotes(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_other_notes';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
