import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailboxMgmtClient.json';

export class MailboxMgmtClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/mgmt/mailbox/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async addIndexToRing(numericIndex,  __fetchOptions = {}) {
        let __path = this.base + '/{numericIndex}/_add_index';
        __path = __path.replace('{numericIndex}', encodeURIComponent(numericIndex));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async consolidateDomain( __fetchOptions = {}) {
        let __path = this.base + '/_consolidate';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async consolidateMailbox(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_consolidate';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async deleteIndexFromRing(numericIndex,  __fetchOptions = {}) {
        let __path = this.base + '/{numericIndex}/_remove_index';
        __path = __path.replace('{numericIndex}', encodeURIComponent(numericIndex));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLiteStats( __fetchOptions = {}) {
        let __path = this.base + '/liteStats';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getShardsStats( __fetchOptions = {}) {
        let __path = this.base + '/shardsStats';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async moveIndex(mailboxUid, index, deleteSource,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_move_index';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (index != null) {
            __url.searchParams.append("index", index);
        }
        if (deleteSource != null) {
            __url.searchParams.append("deleteSource", deleteSource);
        }
		return this.__fetchContent(__url, __options);
    }
    async resetMailbox(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_reset';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async respawnMailbox(mailboxUid,  __fetchOptions = {}) {
        let __path = this.base + '/{mailboxUid}/_respawn';
        __path = __path.replace('{mailboxUid}', encodeURIComponent(mailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
