import { 
    TaskRef
} from "@bluemind/core.task.api";

import { ShardStats } from "./ShardStats"; 
import { SimpleShardStats } from "./SimpleShardStats"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IMailboxMgmt {
    addIndexToRing(numericIndex: number,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * reindex all domain mailboxes
     */
    consolidateDomain( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * consolidate a single mailbox alias
     */
    consolidateMailbox(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deleteIndexFromRing(numericIndex: number,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * @returns list of {@link ShardStats} ordered by {@link ShardStats#docCount}
     */
    getLiteStats( __fetchOptions?: RequestOptions): Promise<Array<SimpleShardStats>>;
    /**
     * @returns list of {@link ShardStats} ordered by {@link ShardStats#docCount}
     */
    getShardsStats( __fetchOptions?: RequestOptions): Promise<Array<ShardStats>>;
    /**
     * move ES index
     * @param index ame    indexName must start with mailspool. ex mailspool_2
     */
    moveIndex(mailboxUid: string, index?: string, deleteSource?: boolean,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * reset a single mailbox alias
     */
    resetMailbox(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * respawn a single mailbox alias into a new shard
     */
    respawnMailbox(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
}

export declare class MailboxMgmtClient extends ApiEndPoint implements IMailboxMgmt {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    addIndexToRing(numericIndex: number,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    consolidateDomain( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    consolidateMailbox(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deleteIndexFromRing(numericIndex: number,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getLiteStats( __fetchOptions?: RequestOptions): Promise<Array<SimpleShardStats>>;
    getShardsStats( __fetchOptions?: RequestOptions): Promise<Array<ShardStats>>;
    moveIndex(mailboxUid: string, index?: string, deleteSource?: boolean,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    resetMailbox(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    respawnMailbox(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getMetadata(): EndPointMetadata;
}
