import { 
    TaskRef
} from "@bluemind/core.task.api";

import { Member } from "./Member"; 
import { GroupSearchQuery } from "./GroupSearchQuery"; 
import { Group } from "./Group"; 
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IGroup {
    add(uid: string, members?: Array<Member>,  __fetchOptions?: RequestOptions): Promise<void>;
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Get group from its email
     */
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    /**
     * Get group from its name
     */
    byName(name: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    /**
     * Create group
     */
    create(uid: string, group?: Group,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Create group with external ID
     */
    createWithExtId(uid: string, extid: string, group?: Group,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete group
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Get group from UID
     */
    get(uid?: string,  __fetchOptions?: RequestOptions): Promise<Group>;
    /**
     * Get group from external ID
     */
    getByExtId(extid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    /**
     * Get group from UID
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    /**
     * Get all expanded group members
     * @returns members belonging to this group or its sub-groups
     */
    getExpandedMembers(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<Member>>;
    /**
     * Get User type expanded group members
     * @returns members of type User belonging to this group or its sub-groups
     */
    getExpandedUserMembers(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<Member>>;
    getGroupsWithRoles(roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Get group without mailbox and vcard from UID
     */
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    /**
     * Get all group members
     * @returns members belonging to this group
     */
    getMembers(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<Member>>;
    /**
     * Get all group parents UID
     * @returns parents
     */
    getParents(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    getRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Retrieves a list of all {@link net.bluemind.group.api.Group}s this uid is
     * member of.
     * @param uid the member's unique id
     * @returns a list of groups
     */
    memberOf(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    /**
     * Retrieves a list of all {@link net.bluemind.group.api.Group} uids this uid is
     * member of.
     * @param uid the member's unique id
     * @returns a list of {@link net.bluemind.group.api.Group} uids
     */
    memberOfGroups(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    remove(uid: string, members?: Array<Member>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Search a group
     * @param query group query
     * @returns list of matching groups
     */
    search(query?: GroupSearchQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    setExtId(uid: string, arg1?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    setRoles(uid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Touch group (update direntry, vcard etc..)
     */
    touch(uid: string, update_vcards?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update group
     */
    update(uid: string, group?: Group,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class GroupClient extends ApiEndPoint implements IGroup {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    add(uid: string, members?: Array<Member>,  __fetchOptions?: RequestOptions): Promise<void>;
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    byName(name: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    create(uid: string, group?: Group,  __fetchOptions?: RequestOptions): Promise<void>;
    createWithExtId(uid: string, extid: string, group?: Group,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    get(uid?: string,  __fetchOptions?: RequestOptions): Promise<Group>;
    getByExtId(extid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    getExpandedMembers(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<Member>>;
    getExpandedUserMembers(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<Member>>;
    getGroupsWithRoles(roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Group>>;
    getMembers(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<Member>>;
    getParents(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    getRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    memberOf(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    memberOfGroups(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    remove(uid: string, members?: Array<Member>,  __fetchOptions?: RequestOptions): Promise<void>;
    search(query?: GroupSearchQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    setExtId(uid: string, arg1?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    setRoles(uid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    touch(uid: string, update_vcards?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, group?: Group,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
