
import { BaseDirEntry } from "./BaseDirEntry"; 
/**
 * Class representing {@link DirEntry} search parameters
 */
export type DirEntryQuery = {
    /**
     * Search direction, ascending by default
     */
    order?: DirEntryQuery.Order;
    /**
     * Filter by name
     */
    nameFilter?: string;
    /**
     * True, if the search should ignore hidden {@link DirEntry}s. Default value is
     * True
     */
    hiddenFilter?: boolean;
    /**
     * Filter by email
     */
    emailFilter?: string;
    /**
     * Filter by name or email
     */
    nameOrEmailFilter?: string;
    /**
     * Filter by State (Archived, Active, All)
     */
    stateFilter?: DirEntryQuery.StateFilter;
    /**
     * True, if the search should ignore internal(system) {@link DirEntry}s. Default
     * value is True
     */
    systemFilter?: boolean;
    /**
     * Filter by Kind (USER, GROUP, RESOURCE, MAILSHARE, CALENDAR, ADDRESSBOOK,
     * DOMAIN, ORG_UNIT, EXTERNALUSER)
     */
    kindsFilter?: Array<BaseDirEntry.Kind>;
    /**
     * Filter by UID
     */
    entries?: Array<string>;
    /**
     * Filter by Org Unit Item ids
     */
    orgUnitIds?: Array<number>;
    /**
     * Filter by Account Type
     */
    accountTypeFilter?: BaseDirEntry.AccountType;
    /**
     * Search offset
     */
    from?: number;
    /**
     * Maximal result size, -1 if there is no limit. The default value is -1
     */
    size?: number;
    /**
     * Filter by UID
     */
    entryUidFilter?: Array<string>;
    /**
     * True if the search returns only manageable {@link DirEntry}s (entries where
     * the executing user owns the role MANAGE)
     */
    onlyManagable?: boolean;
    /**
     * Filter by data location
     */
    dataLocation?: string;
    /**
     * Set to true to prevent loading of dependent objects (pictures, org unit
     * infos, etc)
     */
    lightResults?: boolean;
};
export namespace DirEntryQuery {
    export type Order = {
        by?: DirEntryQuery.OrderBy;
        dir?: DirEntryQuery.Dir;
    };
    export type Dir =  "asc" |  "desc";
    export const Dir : {
        readonly asc: Dir,
        readonly desc: Dir
    };
    export type StateFilter =  "Archived" |  "Active" |  "All";
    export const StateFilter : {
        readonly Archived: StateFilter,
        readonly Active: StateFilter,
        readonly All: StateFilter
    };
    export type OrderBy =  "kind" |  "displayname";
    export const OrderBy : {
        readonly kind: OrderBy,
        readonly displayname: OrderBy
    };

}
