import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DirEntryMaintenanceClient.json';

export class DirEntryMaintenanceClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, domain , entryUid , base = '') {
        super(apiKey, base + '/api/directory/{domain}/{entryUid}/mgmt');
        this.domain = domain;
        this.base = this.base.replace('{domain}', encodeURIComponent(domain));
        this.entryUid = entryUid;
        this.base = this.base.replace('{entryUid}', encodeURIComponent(entryUid));
    }
    async getAvailableOperations( __fetchOptions = {}) {
        let __path = this.base + '/_maintenance';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async repair(config,  __fetchOptions = {}) {
        let __path = this.base + '/_maintenance/repair';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (config != null) {
            __options.body = JSON.stringify(config);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
