import { 
    Email
} from "@bluemind/core.foldershare.api";
/**
 * Base class of all directory related entities ({@link DirEntry})
 */
export type DirBaseValue = {
    orgUnitUid?: string;
    /**
     * The {@link DirEntry}'s emails
     */
    emails?: Array<Email>;
    /**
     * True when this {@link DirEntry} must not appear in visible views of other
     * {@link net.bluemind.user.api.User}s
     */
    hidden?: boolean;
    /**
     * True if the {@link DirEntry} is suspended. A suspended {@link DirEntry}
     * cannot sign into the system but its data is still in the system.
     */
    archived?: boolean;
    /**
     * True for some internal {@link DirEntry}, used for specific internal tasks.
     */
    system?: boolean;
    /**
     * Defines on which {@link net.bluemind.server.api.Server} the data owned by
     * this {@link DirEntry} are.
     */
    dataLocation?: string;
};
