
/**
 * Base data structure of all directory related entities
 */
export type BaseDirEntry = {
    displayName?: string;
    /**
     * Unique entry uid
     */
    entryUid?: string;
    /**
     * The {@link DirEntry}'s {@link BaseDirEntry.AccountType} type
     */
    accountType?: BaseDirEntry.AccountType;
    /**
     * The {@link BaseDirEntry.Kind} of the {@link DirEntry}
     */
    kind?: BaseDirEntry.Kind;
};
export namespace BaseDirEntry {
    /**
     * The type of an account.<br>
     * FULL represents an entity with all available applications (messaging,
     * contact, agenda etc.)<br>
     * SIMPLE represents an entity with limited access (no sharing) to the messaging
     * application FULL_AND_VISIO represents an entity having advanced features to
     * the video conferencing functionalities
     */
    export type AccountType =  "FULL" |  "SIMPLE" |  "FULL_AND_VISIO";
    export const AccountType : {
        readonly FULL: AccountType,
        readonly SIMPLE: AccountType,
        readonly FULL_AND_VISIO: AccountType
    };
    /**
     * The kind of object the entry represents.
     */
    export type Kind =  "USER" |  "GROUP" |  "RESOURCE" |  "MAILSHARE" |  "SHARED_MAILBOX" |  "CALENDAR" |  "ADDRESSBOOK" |  "DOMAIN" |  "ORG_UNIT" |  "EXTERNALUSER";
    export const Kind : {
        readonly USER: Kind,
        readonly GROUP: Kind,
        readonly RESOURCE: Kind,
        readonly MAILSHARE: Kind,
        readonly SHARED_MAILBOX: Kind,
        readonly CALENDAR: Kind,
        readonly ADDRESSBOOK: Kind,
        readonly DOMAIN: Kind,
        readonly ORG_UNIT: Kind,
        readonly EXTERNALUSER: Kind
    };

}
