
import { 
    ErrorCode
} from "@bluemind/core.foldershare.api";
export type DPError = {
    message?: string;
    uid?: string;
    type?: DPError.RestoreType;
    kind?: DPError.DPKind;
    errorCode?: ErrorCode;
};
export namespace DPError {
    export type RestoreType =  "RESTORE" |  "EXPORT";
    export const RestoreType : {
        readonly RESTORE: RestoreType,
        readonly EXPORT: RestoreType
    };
    export type DPKind =  "ADDRESSBOOK" |  "CALENDAR" |  "USER" |  "MAILSHARE" |  "DOMAIN_ADDRESSBOOK" |  "DOMAIN_CALENDAR" |  "TODOLISTS" |  "WEBAPPDATA" |  "NOTES" |  "RESOURCE" |  "SHARED_MAILBOX";
    export const DPKind : {
        readonly ADDRESSBOOK: DPKind,
        readonly CALENDAR: DPKind,
        readonly USER: DPKind,
        readonly MAILSHARE: DPKind,
        readonly DOMAIN_ADDRESSBOOK: DPKind,
        readonly DOMAIN_CALENDAR: DPKind,
        readonly TODOLISTS: DPKind,
        readonly WEBAPPDATA: DPKind,
        readonly NOTES: DPKind,
        readonly RESOURCE: DPKind,
        readonly SHARED_MAILBOX: DPKind
    };

}
