
export type Status = {
    /**
     * Status type
     */
    type?: Status.Type;
    /**
     * Status message
     */
    message?: string;
    /**
     * Phone state
     */
    phoneState?: Status.PhoneState;
};
export namespace Status {
    export type PhoneState =  "Unknown" |  "Available" |  "DoNotDisturb" |  "Ringing" |  "Busy" |  "OnHold";
    export const PhoneState : {
        readonly Unknown: PhoneState,
        readonly Available: PhoneState,
        readonly DoNotDisturb: PhoneState,
        readonly Ringing: PhoneState,
        readonly Busy: PhoneState,
        readonly OnHold: PhoneState
    };
    export type Type =  "DoNotDisturb" |  "Available" |  "Busy" |  "Offline";
    export const Type : {
        readonly DoNotDisturb: Type,
        readonly Available: Type,
        readonly Busy: Type,
        readonly Offline: Type
    };

}
