import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './OwnerSubscriptionsClient.json';

export class OwnerSubscriptionsClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, domainUid , ownerUid , base = '') {
        super(apiKey, base + '/api/containers/_subscriptions/{domainUid}/{ownerUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
        this.ownerUid = ownerUid;
        this.base = this.base.replace('{ownerUid}', encodeURIComponent(ownerUid));
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async changesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async filteredChangesetById(since, filter,  __fetchOptions = {}) {
        let __path = this.base + '/_filteredChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (filter != null) {
            __options.body = JSON.stringify(filter);
        }
		return this.__fetchContent(__url, __options);
    }
    async fullChangesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_fullChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getCompleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/{id}/completeById';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMultiple(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async list( __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async multipleGetById(ids,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (ids != null) {
            __options.body = JSON.stringify(ids);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
