/**
 * GENERAL PURPOSE ERRORS
 * 
 * Default HTTP status: 500
 * 
 * @see net.bluemind.core.rest.base.codec.JsonObjectCodec#replyFault()
 */
export type ErrorCode =  "UNKNOWN" |  "BAD_REQUEST" |  "PERMISSION_DENIED" |  "FAILURE" |  "INVALID_ID" |  "INVALID_PARAMETER" |  "AUTHENTICATION_FAIL" |  "SQL_ERROR" |  "NOT_FOUND" |  "ALREADY_EXISTS" |  "FORBIDDEN" |  "ENTITY_TOO_LARGE" |  "INVALID_QUERY" |  "INVALID_XML_RECEIVED" |  "CHILD_GROUP_MUST_EXIST" |  "CANT_DELETE_MYSELF" |  "DELEGATION_RESTRICTION" |  "INVALID_PASSWORD" |  "LOGIN_ALREADY_USED" |  "INVALID_LOGIN" |  "EMPTY_LASTNAME" |  "EMPTY_VACATION_MESSAGE" |  "VACATION_WITHOUT_MAILBOX" |  "FORWARDING_WITHOUT_MAILBOX" |  "FORWARDING_INVALID_EMAIL" |  "INVALID_MAIL_SERVER" |  "INVALID_GROUP_NAME" |  "FORWARDING_TO_OWN_MAILBOX" |  "SAME_PARENT_AND_CHILD_GROUP" |  "INCLUSION_GROUP_LOOP" |  "EMAIL_ALREADY_USED" |  "INVALID_EMAIL" |  "MAIL_QUOTA_OVER_DOMAIN_LIMIT" |  "NOT_GLOBAL_ADMIN" |  "DOMAIN_NAME_ALREADY_USED" |  "INVALID_MAILSHARE_NAME" |  "INVALID_RESOURCE_NAME" |  "OLD_PASSWORD_WRONG" |  "OLD_PASSWORD_SAME_AS_NEW" |  "IP_ADDRESS_ALREADY_USED" |  "MBOX_RENAME_FAILED" |  "INVALID_HOST_NAME" |  "EMPTY_EVENT_TITLE" |  "NO_DURATION_EVENT" |  "NO_EVENT_DATE" |  "NO_EVENT_TYPE" |  "EVENT_PRIVACY_INVALID" |  "EVENT_ERROR" |  "CALENDAR_AUTHORISATION_ERROR" |  "CONTACT_DOMAIN_FORBIDDEN" |  "EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE" |  "INVALID_DOMAIN_NAME" |  "GROUP_NAME_ALREADY_USED" |  "INVALID_VACATION_RANGE" |  "EMPTY_DLIST_LABEL" |  "EMPTY_DLIST_FOLDER" |  "DLIST_LOOP" |  "CANT_UPDATE_ACL_IMPLICIT_RIGHTS" |  "USER_SPLIT_REQUIRES_SPLIT_DOMAIN" |  "SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN" |  "INVALID_USER_LDAP_FILTER" |  "SEC_GROUP_RM" |  "NOT_IN_GLOBAL_DOMAIN" |  "NO_BACKUP_SERVER_FOUND" |  "OPERATION_ALREADY_RUNNING" |  "INVALID_AD_HOST_NAME" |  "JOB_FINISHED" |  "INVALID_LICENSE" |  "HSM_MISSING_POLICY" |  "INCOMPATIBLE_SMTP_TAGS" |  "INVALID_MAILBOX_NAME" |  "TAG_ALREADY_EXIST" |  "INVALID_LINKED_MAILSHARE" |  "MAILSHARE_GROUP_LINKED" |  "SERVER_NOT_FOUND" |  "DEPRECATED" |  "INVALID_GROUP_MEMBER" |  "EMPTY_EVENT_ATTACHMENT_VALUE" |  "TIMEOUT" |  "VERSION_HAS_CHANGED" |  "MULTIPLE_EVENT_COUNTERS" |  "EVENT_ACCEPTS_NO_COUNTERS" |  "EVENT_WEEKDAY_INVALID" |  "EVENT_DUPLICATED_RECURID" |  "MAX_ITEM_COUNT" |  "INVALID_PEM_CERTIFICATE" |  "INVALID_AUTH_PARAMETER";
export const ErrorCode : {
    readonly UNKNOWN: ErrorCode,
    /**
     * HTTP status: 400
     */
    readonly BAD_REQUEST: ErrorCode,
    /**
     * HTTP status: 403
     */
    readonly PERMISSION_DENIED: ErrorCode,
    readonly FAILURE: ErrorCode,
    readonly INVALID_ID: ErrorCode,
    readonly INVALID_PARAMETER: ErrorCode,
    readonly AUTHENTICATION_FAIL: ErrorCode,
    readonly SQL_ERROR: ErrorCode,
    /**
     * HTTP status: 404
     */
    readonly NOT_FOUND: ErrorCode,
    readonly ALREADY_EXISTS: ErrorCode,
    readonly FORBIDDEN: ErrorCode,
    readonly ENTITY_TOO_LARGE: ErrorCode,
    /**
     * Invalid query
     */
    readonly INVALID_QUERY: ErrorCode,
    /**
     * XML received from client is either invalid or not as expected
     */
    readonly INVALID_XML_RECEIVED: ErrorCode,
    /**
     * Child group must exist
     */
    readonly CHILD_GROUP_MUST_EXIST: ErrorCode,
    /**
     * BJR(4)
     */
    readonly CANT_DELETE_MYSELF: ErrorCode,
    /**
     * BJR(5)
     */
    readonly DELEGATION_RESTRICTION: ErrorCode,
    /**
     * BJR(6)
     */
    readonly INVALID_PASSWORD: ErrorCode,
    /**
     * BJR(7)
     */
    readonly LOGIN_ALREADY_USED: ErrorCode,
    /**
     * BJR(8)
     */
    readonly INVALID_LOGIN: ErrorCode,
    /**
     * BJR(9)
     */
    readonly EMPTY_LASTNAME: ErrorCode,
    /**
     * BJR(10)
     */
    readonly EMPTY_VACATION_MESSAGE: ErrorCode,
    /**
     * BJR(11)
     */
    readonly VACATION_WITHOUT_MAILBOX: ErrorCode,
    /**
     * BJR(12)
     */
    readonly FORWARDING_WITHOUT_MAILBOX: ErrorCode,
    /**
     * BJR(14)
     */
    readonly FORWARDING_INVALID_EMAIL: ErrorCode,
    /**
     * BJR(16)
     */
    readonly INVALID_MAIL_SERVER: ErrorCode,
    /**
     * BJR(17)
     */
    readonly INVALID_GROUP_NAME: ErrorCode,
    /**
     * BJR(19)
     */
    readonly FORWARDING_TO_OWN_MAILBOX: ErrorCode,
    /**
     * BJR(20)
     */
    readonly SAME_PARENT_AND_CHILD_GROUP: ErrorCode,
    /**
     * BJR(21)
     */
    readonly INCLUSION_GROUP_LOOP: ErrorCode,
    /**
     * BJR(23)
     */
    readonly EMAIL_ALREADY_USED: ErrorCode,
    /**
     * BJR(24)
     */
    readonly INVALID_EMAIL: ErrorCode,
    /**
     * BJR(25)
     */
    readonly MAIL_QUOTA_OVER_DOMAIN_LIMIT: ErrorCode,
    /**
     * BJR(29)
     */
    readonly NOT_GLOBAL_ADMIN: ErrorCode,
    /**
     * BJR(30)
     */
    readonly DOMAIN_NAME_ALREADY_USED: ErrorCode,
    /**
     * BJR(31)
     */
    readonly INVALID_MAILSHARE_NAME: ErrorCode,
    /**
     * BJR(74)
     */
    readonly INVALID_RESOURCE_NAME: ErrorCode,
    /**
     * BJR(33)
     */
    readonly OLD_PASSWORD_WRONG: ErrorCode,
    /**
     * BJR(34)
     */
    readonly OLD_PASSWORD_SAME_AS_NEW: ErrorCode,
    /**
     * BJR(38)
     */
    readonly IP_ADDRESS_ALREADY_USED: ErrorCode,
    /**
     * Failure on Cyrus rename command
     */
    readonly MBOX_RENAME_FAILED: ErrorCode,
    /**
     * BJR(40)
     */
    readonly INVALID_HOST_NAME: ErrorCode,
    /**
     * BJR(45)
     */
    readonly EMPTY_EVENT_TITLE: ErrorCode,
    /**
     * BJR(46)
     */
    readonly NO_DURATION_EVENT: ErrorCode,
    /**
     * BJR(46)
     */
    readonly NO_EVENT_DATE: ErrorCode,
    /**
     * BJR(46)
     */
    readonly NO_EVENT_TYPE: ErrorCode,
    /**
     * BJR(46)
     */
    readonly EVENT_PRIVACY_INVALID: ErrorCode,
    /**
     * BJR(xx) Autres erreurs improbables (default values not null set to null)
     */
    readonly EVENT_ERROR: ErrorCode,
    /**
     * BJR(50)
     */
    readonly CALENDAR_AUTHORISATION_ERROR: ErrorCode,
    /**
     * BJR(51)
     */
    readonly CONTACT_DOMAIN_FORBIDDEN: ErrorCode,
    /**
     * BJR(53)
     */
    readonly EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE: ErrorCode,
    /**
     * 
     */
    readonly INVALID_DOMAIN_NAME: ErrorCode,
    /**
     * 
     */
    readonly GROUP_NAME_ALREADY_USED: ErrorCode,
    /**
     * 
     */
    readonly INVALID_VACATION_RANGE: ErrorCode,
    /**
     * 
     */
    readonly EMPTY_DLIST_LABEL: ErrorCode,
    /**
     * 
     */
    readonly EMPTY_DLIST_FOLDER: ErrorCode,
    /**
     * 
     */
    readonly DLIST_LOOP: ErrorCode,
    /**
     * 
     */
    readonly CANT_UPDATE_ACL_IMPLICIT_RIGHTS: ErrorCode,
    /**
     * 
     */
    readonly USER_SPLIT_REQUIRES_SPLIT_DOMAIN: ErrorCode,
    /**
     * 
     */
    readonly SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN: ErrorCode,
    /**
     * 
     */
    readonly INVALID_USER_LDAP_FILTER: ErrorCode,
    /**
     * 
     */
    readonly SEC_GROUP_RM: ErrorCode,
    /**
     * 
     */
    readonly NOT_IN_GLOBAL_DOMAIN: ErrorCode,
    /**
     * 
     */
    readonly NO_BACKUP_SERVER_FOUND: ErrorCode,
    /**
     * 
     */
    readonly OPERATION_ALREADY_RUNNING: ErrorCode,
    /**
     * 
     */
    readonly INVALID_AD_HOST_NAME: ErrorCode,
    /**
     * Sent when the live logs of a finished jobs are requested
     */
    readonly JOB_FINISHED: ErrorCode,
    /**
     * 
     */
    readonly INVALID_LICENSE: ErrorCode,
    /**
     * No policy is defined on the queried entity
     */
    readonly HSM_MISSING_POLICY: ErrorCode,
    /**
     * Thrown when trying to make an internal server a relay, or the other way
     * around.
     */
    readonly INCOMPATIBLE_SMTP_TAGS: ErrorCode,
    /**
     * 
     */
    readonly INVALID_MAILBOX_NAME: ErrorCode,
    /**
     * 
     */
    readonly TAG_ALREADY_EXIST: ErrorCode,
    /**
     * Thrown when linkin a mailshare to a group is not allowed
     */
    readonly INVALID_LINKED_MAILSHARE: ErrorCode,
    /**
     * A group is linked to a mailshare
     */
    readonly MAILSHARE_GROUP_LINKED: ErrorCode,
    /**
     * 
     */
    readonly SERVER_NOT_FOUND: ErrorCode,
    readonly DEPRECATED: ErrorCode,
    /**
     * 
     */
    readonly INVALID_GROUP_MEMBER: ErrorCode,
    readonly EMPTY_EVENT_ATTACHMENT_VALUE: ErrorCode,
    /**
     * 
     */
    readonly TIMEOUT: ErrorCode,
    /**
     * sent when listing ids in a container with the wrong container version
     */
    readonly VERSION_HAS_CHANGED: ErrorCode,
    /**
     * 
     */
    readonly MULTIPLE_EVENT_COUNTERS: ErrorCode,
    readonly EVENT_ACCEPTS_NO_COUNTERS: ErrorCode,
    readonly EVENT_WEEKDAY_INVALID: ErrorCode,
    readonly EVENT_DUPLICATED_RECURID: ErrorCode,
    /**
     * 
     */
    readonly MAX_ITEM_COUNT: ErrorCode,
    /**
     * 
     */
    readonly INVALID_PEM_CERTIFICATE: ErrorCode,
    /**
     * 
     */
    readonly INVALID_AUTH_PARAMETER: ErrorCode
};
