import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './VFreebusyClient.json';

export class VFreebusyClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/calendars/vfreebusy/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async get(query,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async getAsString(query,  __fetchOptions = {}) {
        let __path = this.base + '/_ics';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
