
import { 
    BmDateTime
} from "@bluemind/core.foldershare.api";
export type PrintOptions = {
    view?: PrintOptions.PrintView;
    format?: PrintOptions.PrintFormat;
    dateBegin?: BmDateTime;
    dateEnd?: BmDateTime;
    color?: boolean;
    showDetail?: boolean;
    showCancelled?: boolean;
    layout?: PrintOptions.PrintLayout;
    calendars?: Array<PrintOptions.CalendarMetadata>;
    tagsFilter?: Array<string>;
};
export namespace PrintOptions {
    export type PrintView =  "DAY" |  "WEEK" |  "MONTH" |  "AGENDA";
    export const PrintView : {
        readonly DAY: PrintView,
        readonly WEEK: PrintView,
        readonly MONTH: PrintView,
        readonly AGENDA: PrintView
    };
    export type PrintLayout =  "PORTRAIT" |  "LANDSCAPE";
    export const PrintLayout : {
        readonly PORTRAIT: PrintLayout,
        readonly LANDSCAPE: PrintLayout
    };
    export type CalendarMetadata = {
        uid?: string;
        color?: string;
    };
    export type PrintFormat =  "SVG" |  "PDF" |  "PNG" |  "JPEG";
    export const PrintFormat : {
        readonly SVG: PrintFormat,
        readonly PDF: PrintFormat,
        readonly PNG: PrintFormat,
        readonly JPEG: PrintFormat
    };

}
