
import { VEventSeries } from "./VEventSeries"; 
import { CalendarsVEventQuery } from "./CalendarsVEventQuery"; 
import { CalendarsVEventRange } from "./CalendarsVEventRange"; 
import { 
    ItemContainerValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ICalendars {
    /**
     * Returns a List of {@link ItemValue} of {@link VEvent}
     */
    multipleGetByRange(range?: CalendarsVEventRange,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VEventSeries>>>;
    /**
     * Returns a {@link ListResult} of {@link ItemValue} of {@link VEvent}
     */
    search(query?: CalendarsVEventQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VEventSeries>>>;
    /**
     * Retrieve a list of pending counter propositions of the current user
     * @param calendars list of calendar uids
     * @returns list of pending counter propositions
     */
    searchPendingCounters(calendars?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VEventSeries>>>;
}

export declare class CalendarsClient extends ApiEndPoint implements ICalendars {
    constructor(apiKey: string, base?: string);
    multipleGetByRange(range?: CalendarsVEventRange,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VEventSeries>>>;
    search(query?: CalendarsVEventQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VEventSeries>>>;
    searchPendingCounters(calendars?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VEventSeries>>>;
    getMetadata(): EndPointMetadata;
}
