import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific calendarview container UIDs.
 */
export interface ICalendarViewUids {
    /**
     * Returns the default user calendarview UID
     * @param uid the {@link net.bluemind.user.api.User} UID
     * @returns default user calendarview UID
     */
    getUserCalendarView(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class CalendarViewUidsClient extends ApiEndPoint implements ICalendarViewUids {
    constructor(apiKey: string, base?: string);
    getUserCalendarView(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
