
import { CalendarViewChanges } from "./CalendarViewChanges"; 
import { CalendarView } from "./CalendarView"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * @deprecated use {@link IUserCalendarViews} containerUid can be constructed
 *             with ({@link ICalendarViewUids#userCalendarView}
 * @deprecated 
 */
export interface ICalendarView {
    /**
     * Creates a {@link CalendarView}
     */
    create(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Deletes a {@link CalendarView}
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Retrieves a {@link CalendarView}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<CalendarView>>;
    /**
     * Returns a list of {@link CalendarView}
     */
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<CalendarView>>>;
    /**
     * Fetch multiple {@link CalendarView}s from theirs uniques uids
     * @returns {@link List<ItemValue<CalendarView>>}
     */
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<CalendarView>>>;
    /**
     * Set user the default view. The default view is used when there is no data to
     * rely on to initialize calendar display.
     */
    setDefault(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Updates a {@link CalendarView}
     */
    update(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Applies changes (create, update, delete) to a calendar specified by its
     * <code>containerUid</code>.
     */
    updates(changes?: CalendarViewChanges,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class CalendarViewClient extends ApiEndPoint implements ICalendarView {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    create(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<CalendarView>>;
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<CalendarView>>>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<CalendarView>>>;
    setDefault(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, view?: CalendarView,  __fetchOptions?: RequestOptions): Promise<void>;
    updates(changes?: CalendarViewChanges,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
