import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './CalendarClient.json';

export class CalendarClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/calendars/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async all( __fetchOptions = {}) {
        let __path = this.base + '/_all';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async changesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async count(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_count';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, event, sendNotifications,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (sendNotifications != null) {
            __url.searchParams.append("sendNotifications", sendNotifications);
        }
        if (event != null) {
            __options.body = JSON.stringify(event);
        }
		return this.__fetchVoid(__url, __options);
    }
    async createById(id, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async delete(uid, sendNotifications,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (sendNotifications != null) {
            __url.searchParams.append("sendNotifications", sendNotifications);
        }
		return this.__fetchVoid(__url, __options);
    }
    async deleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async filteredChangesetById(since, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/_filteredChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async getByIcsUid(uid,  __fetchOptions = {}) {
        let __path = this.base + '/_icsuid/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getCompleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/{id}/completeById';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async isAutoSyncActivated( __fetchOptions = {}) {
        let __path = this.base + '/_isAutoSyncActivated';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async itemChangelog(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_itemchangelog';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async list( __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async multipleDeleteById(arg0, bypassDeletedItems,  __fetchOptions = {}) {
        let __path = this.base + '/_multipleDelete';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (bypassDeletedItems != null) {
            __url.searchParams.append("bypassDeletedItems", bypassDeletedItems);
        }
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchVoid(__url, __options);
    }
    async multipleGet(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleGetById(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleGetByRange(range,  __fetchOptions = {}) {
        let __path = this.base + '/_mget_range';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (range != null) {
            __options.body = JSON.stringify(range);
        }
		return this.__fetchContent(__url, __options);
    }
    async reset( __fetchOptions = {}) {
        let __path = this.base + '/_reset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async search(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async searchPendingCounters( __fetchOptions = {}) {
        let __path = this.base + '/_search_counters';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async sortedIds(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_sorted';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async sortedUids(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_sorteduids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async sync(since, changes,  __fetchOptions = {}) {
        let __path = this.base + '/_sync';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (changes != null) {
            __options.body = JSON.stringify(changes);
        }
		return this.__fetchContent(__url, __options);
    }
    async touch(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_touch';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, event, sendNotifications,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (sendNotifications != null) {
            __url.searchParams.append("sendNotifications", sendNotifications);
        }
        if (event != null) {
            __options.body = JSON.stringify(event);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateById(id, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async updates(changes,  __fetchOptions = {}) {
        let __path = this.base + '/_mupdates';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (changes != null) {
            __options.body = JSON.stringify(changes);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
