import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './AuthenticationClient.json';

export class AuthenticationClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/auth');
    }
    async backchannelLogout(contentStream,  __fetchOptions = {}) {
        let __path = this.base + '/logout/backchannel';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (contentStream != null) {
            __options.body = contentStream;
        }
		return this.__fetchVoid(__url, __options);
    }
    async getCurrentUser( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async login(login, password, origin,  __fetchOptions = {}) {
        let __path = this.base + '/login';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (login != null) {
            __url.searchParams.append("login", login);
        }
        if (origin != null) {
            __url.searchParams.append("origin", origin);
        }
        if (password != null) {
            __options.body = JSON.stringify(password);
        }
		return this.__fetchContent(__url, __options);
    }
    async loginWithParams(login, password, origin, interactive,  __fetchOptions = {}) {
        let __path = this.base + '/loginWithParams';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (login != null) {
            __url.searchParams.append("login", login);
        }
        if (origin != null) {
            __url.searchParams.append("origin", origin);
        }
        if (interactive != null) {
            __url.searchParams.append("interactive", interactive);
        }
        if (password != null) {
            __options.body = JSON.stringify(password);
        }
		return this.__fetchContent(__url, __options);
    }
    async logout( __fetchOptions = {}) {
        let __path = this.base + '/logout';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async ping( __fetchOptions = {}) {
        let __path = this.base + '/ping';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async su(login,  __fetchOptions = {}) {
        let __path = this.base + '/_su';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (login != null) {
            __url.searchParams.append("login", login);
        }
		return this.__fetchContent(__url, __options);
    }
    async suWithParams(login, interactive,  __fetchOptions = {}) {
        let __path = this.base + '/_suWithParams';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (login != null) {
            __url.searchParams.append("login", login);
        }
        if (interactive != null) {
            __url.searchParams.append("interactive", interactive);
        }
		return this.__fetchContent(__url, __options);
    }
    async validate(login, password, origin,  __fetchOptions = {}) {
        let __path = this.base + '/validate';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (login != null) {
            __url.searchParams.append("login", login);
        }
        if (origin != null) {
            __url.searchParams.append("origin", origin);
        }
        if (password != null) {
            __options.body = JSON.stringify(password);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
