
import { LoginResponse } from "./LoginResponse"; 
import { AuthUser } from "./AuthUser"; 
import { ValidationKind } from "./ValidationKind"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Authentication service
 */
export interface IAuthentication {
    /**
     * Back-channel logout
     * 
     * Used for Single-Sign-out from centralized authentication
     */
    backchannelLogout(contentStream?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<void>;
    getCurrentUser( __fetchOptions?: RequestOptions): Promise<AuthUser>;
    /**
     * Try to log in user into Blue-Mind and create valid session on success
     * @param password user password
     * @param origin Blue Mind application from which user try to log in
     * @returns {@link LoginResponse}
     */
    login(login?: string, password?: string, origin?: string,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    /**
     * Try to log in user into Blue-Mind and create valid session on success
     * @param password user password
     * @param origin Blue Mind application from which user try to log in
     * @param interactive interactive
     * @returns {@link LoginResponse}
     */
    loginWithParams(login?: string, password?: string, origin?: string, interactive?: boolean,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    /**
     * Close a Blue-Mind session
     */
    logout( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Refreshes the session, or throws exception if the SecurityContext is invalid.
     */
    ping( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Create Blue-Mind access token for requested user.<br>
     * This token can be used for authenticate against Blue-Mind components
     * <p>
     * Only token from global domain are allowed to do this.
     * @param login requested login@domain access token
     * @returns {@link LoginResponse}
     */
    su(login?: string,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    suWithParams(login?: string, interactive?: boolean,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    /**
     * Validate credential
     * @param password user password
     * @param origin Blue Mind application from which user try to log in
     * @returns {@link LoginResponse}
     */
    validate(login?: string, password?: string, origin?: string,  __fetchOptions?: RequestOptions): Promise<ValidationKind>;
}

export declare class AuthenticationClient extends ApiEndPoint implements IAuthentication {
    constructor(apiKey: string, base?: string);
    backchannelLogout(contentStream?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<void>;
    getCurrentUser( __fetchOptions?: RequestOptions): Promise<AuthUser>;
    login(login?: string, password?: string, origin?: string,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    loginWithParams(login?: string, password?: string, origin?: string, interactive?: boolean,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    logout( __fetchOptions?: RequestOptions): Promise<void>;
    ping( __fetchOptions?: RequestOptions): Promise<void>;
    su(login?: string,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    suWithParams(login?: string, interactive?: boolean,  __fetchOptions?: RequestOptions): Promise<LoginResponse>;
    validate(login?: string, password?: string, origin?: string,  __fetchOptions?: RequestOptions): Promise<ValidationKind>;
    getMetadata(): EndPointMetadata;
}
