
import { APIKey } from "./APIKey"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IAPIKeys {
    /**
     * Creates an {@link APIKey} for the given core session. This will be usable as
     * a valid password to impersonate the user.
     * @param displayName the name of the {@link APIKey}
     * @returns an {@link APIKey} to impersonate the user
     */
    create(displayName?: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
    /**
     * Deletes an {@link APIKey}
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * @returns a List of {@link APIKey}
     */
    list( __fetchOptions?: RequestOptions): Promise<Array<APIKey>>;
    /**
     * Put an {@link APIKey} SID for the given core session. This will be usable as
     * a valid password to impersonate the user.
     * @param displayName the name of the {@link APIKey}
     * @param sid the SID of the {@link APIKey}
     * @returns UID of {@link APIKey}
     */
    put(displayName?: string, sid?: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class APIKeysClient extends ApiEndPoint implements IAPIKeys {
    constructor(apiKey: string, base?: string);
    create(displayName?: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    list( __fetchOptions?: RequestOptions): Promise<Array<APIKey>>;
    put(displayName?: string, sid?: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
