import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './AttachmentClient.json';

export class AttachmentClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/attachment/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async getConfiguration( __fetchOptions = {}) {
        let __path = this.base + '/_config';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async share(name, document,  __fetchOptions = {}) {
        let __path = this.base + '/{name}/share';
        __path = __path.replace('{name}', encodeURIComponent(name));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (document != null) {
            __options.body = document;
        }
		return this.__fetchContent(__url, __options);
    }
    async shareDedup(extension, document,  __fetchOptions = {}) {
        let __path = this.base + '/{extension}/share_dedup';
        __path = __path.replace('{extension}', encodeURIComponent(extension));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (document != null) {
            __options.body = document;
        }
		return this.__fetchContent(__url, __options);
    }
    async unShare(url,  __fetchOptions = {}) {
        let __path = this.base + '/{url}/unshare';
        __path = __path.replace('{url}', encodeURIComponent(url));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
