export class ProgressMonitor {
    static UPLOAD: ProgressMonitorMode;
    static DOWNLOAD: ProgressMonitorMode;
    static BOTH: ProgressMonitorMode;

    private listeners: ProgresMonitorListener[];
    private download?: XMLHttpRequestEventTarget;
    private upload?: XMLHttpRequestUpload;

    constructor();
    
    addEventListener(
        type: ProgressEventType,
        listener: (this: XMLHttpRequestEventTarget, ev: ProgressEvent<XMLHttpRequestEventTarget>) => unknown,
        options?: boolean | (AddEventListenerOptions & { mode?: ProgressMonitorMode })
    ): void ;
    removeEventListener(
        type: ProgressEventType,
        listener: (this: XMLHttpRequestEventTarget, ev: ProgressEvent<XMLHttpRequestEventTarget>) => unknown,
        options?: boolean | (EventListenerOptions & { mode?: ProgressMonitorMode })
    ): void ;
}

export function setupProgressMonitor(monitor: ProgressMonitor, target: XMLHttpRequest): void;
export function tearDownProgressMonitor(monitor: ProgressMonitor): void;

type ProgressEventType = keyof XMLHttpRequestEventTargetEventMap;
type ProgressMonitorMode = 0 | 1 | 2 | 3;

type ProgresMonitorListener = {
    type: ProgressEventType;
    callback: (this: XMLHttpRequestEventTarget, ev: ProgressEvent<XMLHttpRequestEventTarget>) => unknown;
    options: AddEventListenerOptions & { mode: ProgressMonitorMode };
};
