import { 
    TaskRef
} from "@bluemind/core.task.api";
import { 
    ContainerDescriptor
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Todolist indexing API
 */
export interface ITodoListsMgmt {
    create(containerUid: string, descriptor?: ContainerDescriptor, isDefault?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(containerUid: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    /**
     * Reindex a Todolist
     * @returns {@link net.bluemind.core.task.api.TaskRef} which can be used to track
     *         this asynchronous operation
     */
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Reindex all Todolists
     * @returns {@link net.bluemind.core.task.api.TaskRef} which can be used to track
     *         this asynchronous operation
     */
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    update(containerUid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class TodoListsMgmtClient extends ApiEndPoint implements ITodoListsMgmt {
    constructor(apiKey: string, base?: string);
    create(containerUid: string, descriptor?: ContainerDescriptor, isDefault?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(containerUid: string,  __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    update(containerUid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
