
export type SubscriptionInformations = {
    version?: string;
    installationVersion?: string;
    customer?: string;
    customerCode?: string;
    dealer?: string;
    distributor?: string;
    kind?: SubscriptionInformations.Kind;
    starts?: number;
    ends?: number;
    valid?: boolean;
    pubKeyFingerprint?: string;
    validProvider?: boolean;
    fromTechVersion?: string;
    indicator?: Array<SubscriptionInformations.InstallationIndicator>;
    contacts?: Array<string>;
    messages?: Array<SubscriptionInformations.Message>;
};
export namespace SubscriptionInformations {
    export type Kind =  "NONE" |  "FREE" |  "TRIAL" |  "PROD" |  "HOST";
    export const Kind : {
        readonly NONE: Kind,
        readonly FREE: Kind,
        readonly TRIAL: Kind,
        readonly PROD: Kind,
        readonly HOST: Kind
    };
    export type Message = {
        kind?: SubscriptionInformations.Message.Kind;
        code?: SubscriptionInformations.Message.Code;
        message?: string;
    };
    export namespace Message {
        export type Kind =  "Warning" |  "Error";
        export const Kind : {
            readonly Warning: Kind,
            readonly Error: Kind
        };
        export type Code =  "Unknown" |  "InvalidSignature" |  "MaxAccounts" |  "Expired";
        export const Code : {
            readonly Unknown: Code,
            readonly InvalidSignature: Code,
            readonly MaxAccounts: Code,
            readonly Expired: Code
        };

    }
    export type InstallationIndicator = {
        kind?: SubscriptionInformations.InstallationIndicator.Kind;
        maxValue?: number;
        currentValue?: number;
        expiration?: number;
    };
    export namespace InstallationIndicator {
        export type Kind =  "FullUser" |  "SimpleUser" |  "FullVisioAccount";
        export const Kind : {
            readonly FullUser: Kind,
            readonly SimpleUser: Kind,
            readonly FullVisioAccount: Kind
        };

    }

}
