
import { InstallationVersion } from "./InstallationVersion"; 
import { PublicInfos } from "./PublicInfos"; 
import { SubscriptionInformations } from "./SubscriptionInformations"; 
import { UpgradeStatus } from "./UpgradeStatus"; 
import { SystemState } from "./SystemState"; 
import { CloneConfiguration } from "./CloneConfiguration"; 
import { CustomLogo } from "./CustomLogo"; 
import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IInstallation {
    clone(sourceParams?: CloneConfiguration,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deleteLogo( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * The instance will stop handling write requests then will write a BYE message
     * into kafka to relinquish control to the clone.
     */
    demoteLeader( __fetchOptions?: RequestOptions): Promise<void>;
    getHostReport( __fetchOptions?: RequestOptions): Promise<string>;
    getInfos( __fetchOptions?: RequestOptions): Promise<PublicInfos>;
    getLogo( __fetchOptions?: RequestOptions): Promise<CustomLogo>;
    getSubscriptionContacts( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getSubscriptionInformations( __fetchOptions?: RequestOptions): Promise<SubscriptionInformations>;
    getSubscriptionKind( __fetchOptions?: RequestOptions): Promise<SubscriptionInformations.Kind>;
    getSystemState( __fetchOptions?: RequestOptions): Promise<SystemState>;
    getVersion( __fetchOptions?: RequestOptions): Promise<InstallationVersion>;
    initialize( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    isValidProductionSubscription( __fetchOptions?: RequestOptions): Promise<boolean>;
    maintenanceMode( __fetchOptions?: RequestOptions): Promise<void>;
    markSchemaAsUpgraded( __fetchOptions?: RequestOptions): Promise<void>;
    ping(ip: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Run post-installation upgraders
     */
    postinst( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    promoteLeader( __fetchOptions?: RequestOptions): Promise<void>;
    removeSubscription( __fetchOptions?: RequestOptions): Promise<void>;
    resetIndex(index: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    resetIndexes( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    runningMode( __fetchOptions?: RequestOptions): Promise<void>;
    sendHostReport( __fetchOptions?: RequestOptions): Promise<string>;
    setLogo(logo?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    setSubscriptionContacts(emails?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    updateSubscription(licence?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update subscription URL to given version on all servers
     * @param version target version. Special versions:
     *                <ul>
     *                <li><i>latest</i> targets the latest published version of
     *                installed BlueMind major version</li>
     *                <li><i>current</i> targets the current installed version of
     *                BlueMind</li>
     *                </ul>
     */
    updateSubscriptionVersion(version?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    updateSubscriptionWithArchive(archive?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<void>;
    upgrade( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    upgradeStatus( __fetchOptions?: RequestOptions): Promise<UpgradeStatus>;
}

export declare class InstallationClient extends ApiEndPoint implements IInstallation {
    constructor(apiKey: string, base?: string);
    clone(sourceParams?: CloneConfiguration,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deleteLogo( __fetchOptions?: RequestOptions): Promise<void>;
    demoteLeader( __fetchOptions?: RequestOptions): Promise<void>;
    getHostReport( __fetchOptions?: RequestOptions): Promise<string>;
    getInfos( __fetchOptions?: RequestOptions): Promise<PublicInfos>;
    getLogo( __fetchOptions?: RequestOptions): Promise<CustomLogo>;
    getSubscriptionContacts( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getSubscriptionInformations( __fetchOptions?: RequestOptions): Promise<SubscriptionInformations>;
    getSubscriptionKind( __fetchOptions?: RequestOptions): Promise<SubscriptionInformations.Kind>;
    getSystemState( __fetchOptions?: RequestOptions): Promise<SystemState>;
    getVersion( __fetchOptions?: RequestOptions): Promise<InstallationVersion>;
    initialize( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    isValidProductionSubscription( __fetchOptions?: RequestOptions): Promise<boolean>;
    maintenanceMode( __fetchOptions?: RequestOptions): Promise<void>;
    markSchemaAsUpgraded( __fetchOptions?: RequestOptions): Promise<void>;
    ping(ip: string,  __fetchOptions?: RequestOptions): Promise<void>;
    postinst( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    promoteLeader( __fetchOptions?: RequestOptions): Promise<void>;
    removeSubscription( __fetchOptions?: RequestOptions): Promise<void>;
    resetIndex(index: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    resetIndexes( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    runningMode( __fetchOptions?: RequestOptions): Promise<void>;
    sendHostReport( __fetchOptions?: RequestOptions): Promise<string>;
    setLogo(logo?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    setSubscriptionContacts(emails?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    updateSubscription(licence?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    updateSubscriptionVersion(version?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    updateSubscriptionWithArchive(archive?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<void>;
    upgrade( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    upgradeStatus( __fetchOptions?: RequestOptions): Promise<UpgradeStatus>;
    getMetadata(): EndPointMetadata;
}
