import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific mailbox ACL container UIDs. This container is used to share
 * access to a mailbox
 */
export interface IMailboxAclUids {
    /**
     * Returns the mailbox ACL UID
     * @param uid the {@link net.bluemind.mailbox.api.Mailbox} UID
     * @returns mailbox ACL UID
     */
    getUidForMailbox(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class MailboxAclUidsClient extends ApiEndPoint implements IMailboxAclUids {
    constructor(apiKey: string, base?: string);
    getUidForMailbox(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
