
import { DocumentMetadata } from "./DocumentMetadata"; 
import { Document } from "./Document"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Document APIs.
 */
export interface IDocument {
    /**
     * Creates a new {@link Document} entry
     */
    create(uid: string, doc?: Document,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Deletes a {@link Document} entry
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetches a {@link Document} entry
     */
    fetch(uid: string,  __fetchOptions?: RequestOptions): Promise<Document>;
    /**
     * Fetches {@link Document} metadata {@link DocumentMetadata}
     */
    fetchMetadata(uid: string,  __fetchOptions?: RequestOptions): Promise<DocumentMetadata>;
    /**
     * Retrives all {@link Document} metadata {@link DocumentMetadata}
     */
    list( __fetchOptions?: RequestOptions): Promise<Array<DocumentMetadata>>;
    /**
     * Updates a {@link Document} entry
     */
    update(uid: string, doc?: Document,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class DocumentClient extends ApiEndPoint implements IDocument {
    containerUid: string;
    itemUid: string;
    constructor(apiKey: string, containerUid: string, itemUid: string, base?: string);
    create(uid: string, doc?: Document,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    fetch(uid: string,  __fetchOptions?: RequestOptions): Promise<Document>;
    fetchMetadata(uid: string,  __fetchOptions?: RequestOptions): Promise<DocumentMetadata>;
    list( __fetchOptions?: RequestOptions): Promise<Array<DocumentMetadata>>;
    update(uid: string, doc?: Document,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
