
import { DataProtectGeneration } from "./DataProtectGeneration"; 
import { RestoreDefinition } from "./RestoreDefinition"; 
import { RestoreOperation } from "./RestoreOperation"; 
import { RetentionPolicy } from "./RetentionPolicy"; 
import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IDataProtect {
    /**
     * Removes protected data
     */
    forget(generationId?: number,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Returns all protected generations, ordered from oldest to most recent
     */
    getAvailableGenerations( __fetchOptions?: RequestOptions): Promise<Array<DataProtectGeneration>>;
    /**
     * Loads an index of protected datas with possible restore actions.
     * @returns {@link GenerationContent} XML from {@link TaskStatus} result
     */
    getContent(partGen: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Returns infos about the restore operations that the core provides
     */
    getRestoreCapabilities( __fetchOptions?: RequestOptions): Promise<Array<RestoreOperation>>;
    /**
     * * Returns infos about the restore operations that the core provides (filtered
     * by tags)
     */
    getRestoreCapabilitiesByTags(tags?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<RestoreOperation>>;
    /**
     * Returns the {@link RetentionPolicy} used for backup automatic removals. Never
     * returns <code>null</code>.
     */
    getRetentionPolicy( __fetchOptions?: RequestOptions): Promise<RetentionPolicy>;
    /**
     * Executes a restore operation on the given {@link Restorable} item using data
     * from a {@link DataProtectGeneration}
     */
    run(restoreDefinition?: RestoreDefinition,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Run the incremental dataprotect backup process
     */
    saveAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Re-creates the in-database metadata using the generations.xml index from the
     * data protect spool on the filesystem.
     *
     * This is used for re-creating a blue mind server using backups. This must be
     * used when /var/backups/bluemind becomes inconsistent with the database
     * content (eg. after a TINA restore of /var/backups/bluemind)
     */
    syncWithFilesystem( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * creates or updates the {@link RetentionPolicy}.
     */
    updatePolicy(rp?: RetentionPolicy,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class DataProtectClient extends ApiEndPoint implements IDataProtect {
    constructor(apiKey: string, base?: string);
    forget(generationId?: number,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getAvailableGenerations( __fetchOptions?: RequestOptions): Promise<Array<DataProtectGeneration>>;
    getContent(partGen: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getRestoreCapabilities( __fetchOptions?: RequestOptions): Promise<Array<RestoreOperation>>;
    getRestoreCapabilitiesByTags(tags?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<RestoreOperation>>;
    getRetentionPolicy( __fetchOptions?: RequestOptions): Promise<RetentionPolicy>;
    run(restoreDefinition?: RestoreDefinition,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    saveAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    syncWithFilesystem( __fetchOptions?: RequestOptions): Promise<void>;
    updatePolicy(rp?: RetentionPolicy,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
