
import { Status } from "./Status"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IComputerTelephonyIntegration {
    dial(number?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Set forward for a componnent
     */
    forward(component: string, phoneNumber?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Retrieve user phone status
     * @returns phone status
     */
    getStatus( __fetchOptions?: RequestOptions): Promise<Status>;
    /**
     * Retrieve users email list from the cti implementation
     * @returns users email list
     */
    getUserEmails( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Set phone status for a component
     */
    setStatus(component: string, status?: Status,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class ComputerTelephonyIntegrationClient extends ApiEndPoint implements IComputerTelephonyIntegration {
    domainUid: string;
    userUid: string;
    constructor(apiKey: string, domainUid: string, userUid: string, base?: string);
    dial(number?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    forward(component: string, phoneNumber?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getStatus( __fetchOptions?: RequestOptions): Promise<Status>;
    getUserEmails( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    setStatus(component: string, status?: Status,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
