import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './TaskClient.json';

export class TaskClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, taskId , base = '') {
        super(apiKey, base + '/api/tasks/{taskId}');
        this.taskId = taskId;
        this.base = this.base.replace('{taskId}', encodeURIComponent(taskId));
    }
    async getCurrentLogs(offset,  __fetchOptions = {}) {
        let __path = this.base + '/_currentLogs';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (offset != null) {
            __url.searchParams.append("offset", offset);
        }
		return this.__fetchContent(__url, __options);
    }
    async log( __fetchOptions = {}) {
        let __path = this.base + '/_log';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        return this.__fetchBlob(__url, __options);
    }
    async status( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
