
import { TaskStatus } from "./TaskStatus"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * @param taskId task identifier
 */
export interface ITask {
    getCurrentLogs(offset?: number,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * retrieve task log (open until task end)
     * @returns Stream of log
     */
    log( __fetchOptions?: RequestOptions): Promise<Blob>;
    /**
     * retrieve task status
     * @returns {@code TaskStatus}
     */
    status( __fetchOptions?: RequestOptions): Promise<TaskStatus>;
}

export declare class TaskClient extends ApiEndPoint implements ITask {
    taskId: string;
    constructor(apiKey: string, taskId: string, base?: string);
    getCurrentLogs(offset?: number,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    log( __fetchOptions?: RequestOptions): Promise<Blob>;
    status( __fetchOptions?: RequestOptions): Promise<TaskStatus>;
    getMetadata(): EndPointMetadata;
}
