
import { ItemFlag } from "./ItemFlag"; 
/**
 * Descriptor of an item
 */
export type ItemDescriptor = {
    /**
     * item uid
     */
    uid?: string;
    /**
     * item version
     */
    version?: number;
    /**
     * item displayname
     */
    displayName?: string;
    /**
     * item external id
     */
    externalId?: string;
    /**
     * The item internal id, use carefully, prefer {@link ItemDescriptor#uid} if
     * possible
     */
    internalId?: number;
    /**
     * creation author
     */
    createdBy?: string;
    /**
     * modification author
     */
    updatedBy?: string;
    /**
     * creation date
     */
    created?: number;
    /**
     * modification date
     */
    updated?: number;
    flags?: Array<ItemFlag>;
};
