import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ReadOnlyMailboxFoldersClient.json';

export class ReadOnlyMailboxFoldersClient extends ApiEndPoint {
    version = "5.5.3184";
    constructor(apiKey, container , base = '') {
        super(apiKey, base + '/api/db_replicated_mailboxes_folders/{container}');
        this.container = container;
        this.base = this.base.replace('{container}', encodeURIComponent(container));
    }
    async all( __fetchOptions = {}) {
        let __path = this.base + '/_all';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byName(name,  __fetchOptions = {}) {
        let __path = this.base + '/byName/{name}';
        __path = __path.replace('{name}', encodeURIComponent(name));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async changesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async childrensOf(folderUid,  __fetchOptions = {}) {
        let __path = this.base + '/childensof/{folderUid}';
        __path = __path.replace('{folderUid}', encodeURIComponent(folderUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async filteredChangesetById(since, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/_filteredChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getFullName(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/fullname';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async itemChangelog(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_itemchangelog';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async root( __fetchOptions = {}) {
        let __path = this.base + '/_root';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async searchItems(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async trash( __fetchOptions = {}) {
        let __path = this.base + '/_trash';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
