
import { FlagUpdate } from "./FlagUpdate"; 
import { ImapItemIdentifier } from "./ImapItemIdentifier"; 
import { MailboxItem } from "./MailboxItem"; 
import { 
    ItemIdentifier,
    ContainerChangeset,
    ItemFlagFilter,
    ItemValue,
    Ack,
    SortDescriptor,
    Count,
    ItemChangelog,
    ItemVersion
} from "@bluemind/core.container.api";
import { 
    BmDateTime
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Container of {@link MailboxItem}.
 *
 * The container is created by the {@link IMailboxFolders} service when a new
 * replicated folder is created.
 */
export interface IMailboxItems {
    /**
     * Add one flag to multiple {@link MailboxItem}.
     * @returns the new container version
     */
    addFlag(flagUpdate?: FlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    create(value?: MailboxItem,  __fetchOptions?: RequestOptions): Promise<ImapItemIdentifier>;
    createById(id: number, arg1?: MailboxItem,  __fetchOptions?: RequestOptions): Promise<Ack>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete one flag to multiple {@link MailboxItem}.
     * @returns the new container version
     */
    deleteFlag(flagUpdate?: FlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Mark deleted items as ready for removal. Physical will removal will occur
     * later (cyr_expire & co)
     */
    expunge( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch a single part from an email mime tree. The address, encoding & charset
     * are specified in the {@link Part} objects from {@link MessageBody#structure}.
     * @param encoding set null to fetch pristine part
     * @param mime override the mime type of the response
     * @param charset override the charset of the response
     * @param filename set a part name (useful for download purpose)
     * @returns a stream of the (optionally) decoded part
     */
    fetch(imapUid: number, address: string, encoding?: string, mime?: string, charset?: string, filename?: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
    /**
     * @returns 
     */
    fetchComplete(imapUid: number,  __fetchOptions?: RequestOptions): Promise<Blob>;
    /**
     * @returns 
     */
    fetchCompleteByGuid(guid: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxItem>>;
    /**
     * Decompose EML in temporary parts, useful to update drafts
     * @returns message structure with temporary addresses
     */
    getForUpdate(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxItem>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    listItemIdsAfter(before?: BmDateTime,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxItem>>>;
    /**
     * Re-injects multiple items into the current folder
     * @param itemIds the item ids of deleted or deleted+expunged messages
     * @returns 
     */
    multipleUnexpungeById(itemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    /**
     * Get the list of {@link ItemValue#internalId} for {@link MailboxItem}
     * delivered or updated after or at the given date.
     * @returns 
     */
    recentItems(deliveredOrUpdatedAfter?: number,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    /**
     * Remove a part uploaded through {@link IMailboxItems#uploadPart(Stream)}
     * @param partId an address returned by a previous <code>uploadPart</code> call
     */
    removePart(partId: string,  __fetchOptions?: RequestOptions): Promise<void>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Re-injects a deleted item into the current folder
     * @param itemId the item id of a deleted or deleted+expunged message
     * @returns 
     */
    unexpunge(itemId: number,  __fetchOptions?: RequestOptions): Promise<ItemIdentifier>;
    /**
     * Get the list of unread items, applying the per-user overlay when dealing with
     * a shared folder.
     * @returns the list of {@link ItemValue#internalId}
     */
    unreadItems( __fetchOptions?: RequestOptions): Promise<Array<number>>;
    updateById(id: number, arg1?: MailboxItem,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Upload an email part (eg. attachment, html body). The returned address can be
     * used as {@link Part#address} when creating or updating a {@link MailboxItem}.
     *
     * The uploaded parts need to be cleaned-up explicitly with
     * {@link IMailboxItems#removePart(String)}
     * @param part a re-usable email part.
     * @returns an address usable as {@link Part#address}
     */
    uploadPart(part?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class MailboxItemsClient extends ApiEndPoint implements IMailboxItems {
    replicatedMailboxUid: string;
    constructor(apiKey: string, replicatedMailboxUid: string, base?: string);
    addFlag(flagUpdate?: FlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    create(value?: MailboxItem,  __fetchOptions?: RequestOptions): Promise<ImapItemIdentifier>;
    createById(id: number, arg1?: MailboxItem,  __fetchOptions?: RequestOptions): Promise<Ack>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteFlag(flagUpdate?: FlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    expunge( __fetchOptions?: RequestOptions): Promise<void>;
    fetch(imapUid: number, address: string, encoding?: string, mime?: string, charset?: string, filename?: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
    fetchComplete(imapUid: number,  __fetchOptions?: RequestOptions): Promise<Blob>;
    fetchCompleteByGuid(guid: string,  __fetchOptions?: RequestOptions): Promise<Blob>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxItem>>;
    getForUpdate(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxItem>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    listItemIdsAfter(before?: BmDateTime,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxItem>>>;
    multipleUnexpungeById(itemIds?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    recentItems(deliveredOrUpdatedAfter?: number,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    removePart(partId: string,  __fetchOptions?: RequestOptions): Promise<void>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    unexpunge(itemId: number,  __fetchOptions?: RequestOptions): Promise<ItemIdentifier>;
    unreadItems( __fetchOptions?: RequestOptions): Promise<Array<number>>;
    updateById(id: number, arg1?: MailboxItem,  __fetchOptions?: RequestOptions): Promise<Ack>;
    uploadPart(part?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
