
export type AccessTokenInfo = {
    status?: AccessTokenInfo.TokenStatus;
    externalAuthEndPointUrl?: string;
    internalRedirectUrl?: string;
    applicationId?: string;
    state?: string;
    codeChallenge?: string;
    codeChallengeMethod?: string;
    responseType?: string;
    scope?: string;
    url?: string;
};
export namespace AccessTokenInfo {
    export type TokenStatus =  "NO_TOKEN_NEEDED" |  "TOKEN_OK" |  "TOKEN_NOT_VALID";
    export const TokenStatus : {
        readonly NO_TOKEN_NEEDED: TokenStatus,
        readonly TOKEN_OK: TokenStatus,
        readonly TOKEN_NOT_VALID: TokenStatus
    };

}
