
import { Configuration } from "./Configuration"; 
import { AttachedFile } from "./AttachedFile"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * API used in conjunction with
 * {@link net.bluemind.filehosting.api.IFileHosting} to share mail attachments
 * by replacing them with a link
 */
export interface IAttachment {
    /**
     * Retrieves the configuration
     * @returns the Filehosting service configuration
     */
    getConfiguration( __fetchOptions?: RequestOptions): Promise<Configuration>;
    /**
     * Share a mail attachment
     * @param name the filename
     * @param document {@link net.bluemind.core.api.Stream} of the file data
     * @returns {@link AttachedFile} containg informations about the shared file
     */
    share(name: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<AttachedFile>;
    /**
     * Share a mail attachment. If a document with the same hash already exists, it
     * will not be uploaded.
     * @param extension the extension to use for the file (eg. 'png')
     * @param document {@link net.bluemind.core.api.Stream} of the file data
     * @returns {@link AttachedFile} containg informations about the shared file
     */
    shareDedup(extension: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<AttachedFile>;
    /**
     * Deactivate a link to a shared file
     * @param url Link to the shared file
     */
    unShare(url: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class AttachmentClient extends ApiEndPoint implements IAttachment {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    getConfiguration( __fetchOptions?: RequestOptions): Promise<Configuration>;
    share(name: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<AttachedFile>;
    shareDedup(extension: string, document?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<AttachedFile>;
    unShare(url: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
