import { 
    DirBaseValue,
    BaseDirEntry
} from "@bluemind/directory.api";
import { 
    Mailbox
} from "@bluemind/mailbox.api";
import { 
    VCard
} from "@bluemind/addressbook.api";
/**
 * User represents a specific user, with a login and a password and a list of
 * emails. Informations like firstname, lastname and phones are store in a
 * {@link VCard}.
 *
 * Users are part of a domain (and only one).
 *
 * They are stored as items in a container users_[domainUid].
 */
export type User = DirBaseValue & {
    /**
     * The login of the user. The login at (@) domain name is used to sign-into the
     * system.
     */
    login: string;
    /**
     * The password is set to the clear-text version to update the password. It is
     * never fetched and only a hash of it is stored in the database.
     */
    password?: string;
    /**
     * Last password update date.
     */
    passwordLastChange?: number;
    /**
     * Password must be changed
     */
    passwordMustChange?: boolean;
    /**
     * Password never expire
     */
    passwordNeverExpires?: boolean;
    /**
     * Contact informations for the user (firstname, lastname, phones, etc)
     */
    contactInfos?: VCard;
    /**
     * Defines how mail routing will be done for this user
     */
    routing?: Mailbox.Routing;
    accountType?: BaseDirEntry.AccountType;
    /**
     * User login capabilities
     */
    loginCaps?: boolean;
    /**
     * {@link Mailbox#quota}
     */
    quota?: number;
    /**
     * Order the "clients" (webapp, calendar, contacts) to clear their local data if
     * their data was initialized with a different mailboxCopyGuid.
     */
    mailboxCopyGuid?: string;
    /**
     * Custom properties
     */
    properties?: Record<string, string>;
};
