
import { VTodo } from "./VTodo"; 
export type VTodoChanges = {
    /**
     * updated items
     */
    add?: Array<VTodoChanges.ItemAdd>;
    /**
     * modified items
     */
    modify?: Array<VTodoChanges.ItemModify>;
    /**
     * deleted items
     */
    delete?: Array<VTodoChanges.ItemDelete>;
};
export namespace VTodoChanges {
    export type ItemModify = {
        uid?: string;
        version?: number;
        value?: VTodo;
        sendNotification?: boolean;
    };
    export type ItemAdd = {
        uid?: string;
        value?: VTodo;
        sendNotification?: boolean;
    };
    export type ItemDelete = {
        uid?: string;
        sendNotification?: boolean;
    };

}
