import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './TodoUidsClient.json';

export class TodoUidsClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/todolist/uids');
    }
    async getDefaultUserTodoList(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_default_todolist';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUserCreatedTodoList(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_other_todolist';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
