import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ExternalSystemClient.json';

export class ExternalSystemClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/system/external');
    }
    async getExternalSystem(systemIdentifier,  __fetchOptions = {}) {
        let __path = this.base + '/{systemIdentifier}';
        __path = __path.replace('{systemIdentifier}', encodeURIComponent(systemIdentifier));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getExternalSystems( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getExternalSystemsByAuthKind(authKinds,  __fetchOptions = {}) {
        let __path = this.base + '/_by_authkind';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (authKinds != null) {
            __options.body = JSON.stringify(authKinds);
        }
		return this.__fetchContent(__url, __options);
    }
    async getLogo(systemIdentifier,  __fetchOptions = {}) {
        let __path = this.base + '/{systemIdentifier}/_logo';
        __path = __path.replace('{systemIdentifier}', encodeURIComponent(systemIdentifier));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async testConnection(systemIdentifier, account,  __fetchOptions = {}) {
        let __path = this.base + '/{systemIdentifier}/_test_connection';
        __path = __path.replace('{systemIdentifier}', encodeURIComponent(systemIdentifier));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (account != null) {
            __options.body = JSON.stringify(account);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
