import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific notes container UIDs
 */
export interface ISmimeCacertUids {
    /**
     * Returns the UID of domain-created certificates list
     * @returns UID
     */
    getDomainCreatedCerts(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class SmimeCacertUidsClient extends ApiEndPoint implements ISmimeCacertUids {
    constructor(apiKey: string, base?: string);
    getDomainCreatedCerts(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
