/**
 * Different ways to reserve a resource
 */
export type ResourceReservationMode =  "OWNER_MANAGED" |  "AUTO_ACCEPT" |  "AUTO_ACCEPT_REFUSE";
export const ResourceReservationMode : {
    /**
     * Resource's participation status remains "pending" until the manager accepts
     * or rejects the invitation.
     */
    readonly OWNER_MANAGED: ResourceReservationMode,
    /**
     * Resource manager receives booking requests and participation is confirmed
     * automatically if the resource is available for the requested timeslot (within
     * working hours and no other booking confirmed).
     */
    readonly AUTO_ACCEPT: ResourceReservationMode,
    /**
     * This mode acts exactly as { {@link #AUTO_ACCEPT } for acceptance. However,
     * with this mode, the resource manager receives booking requests and
     * participation is rejected automatically if the resource is not available for
     * the requested timeslot.
     */
    readonly AUTO_ACCEPT_REFUSE: ResourceReservationMode
};
