
import { MailboxConfig } from "./MailboxConfig"; 
import { RuleMoveDirection } from "./RuleMoveDirection"; 
import { MailFilter } from "./MailFilter"; 
import { Mailbox } from "./Mailbox"; 
import { RuleMoveRelativePosition } from "./RuleMoveRelativePosition"; 
import { DelegationRule } from "./DelegationRule"; 
import { MailboxQuota } from "./MailboxQuota"; 
import { MailFilterRule } from "./MailFilterRule"; 
import { 
    ItemValue,
    AccessControlEntry
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IMailboxes {
    addDomainRule(rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<number>;
    addMailboxRule(mailboxUid: string, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<number>;
    addMailboxRuleRelative(mailboxUid: string, position: RuleMoveRelativePosition, anchorId: number, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<number>;
    byEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailbox>>;
    byName(name?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailbox>>;
    byRouting(email?: Mailbox.Routing,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Creates a new {@link Mailbox} entry.
     * @param uid uid of the entry
     * @param mailbox value of the entry
     */
    create(uid: string, mailbox?: Mailbox,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete {@link Mailbox} entry
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteDomainRule(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteMailboxRule(mailboxUid: string, id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch a {@link Mailbox} from its unique uid
     * @returns {@link ItemValue<Mailbox>}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailbox>>;
    getDomainFilter( __fetchOptions?: RequestOptions): Promise<MailFilter>;
    getDomainRule(id: number,  __fetchOptions?: RequestOptions): Promise<MailFilterRule>;
    getDomainRules( __fetchOptions?: RequestOptions): Promise<Array<MailFilterRule>>;
    getMailboxAccessControlList(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<Array<AccessControlEntry>>;
    getMailboxConfig(uid: string,  __fetchOptions?: RequestOptions): Promise<MailboxConfig>;
    getMailboxDelegationRule(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<DelegationRule>;
    getMailboxFilter(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<MailFilter>;
    getMailboxForwarding(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<MailFilter.Forwarding>;
    getMailboxQuota(uid: string,  __fetchOptions?: RequestOptions): Promise<MailboxQuota>;
    getMailboxRule(mailboxUid: string, id: number,  __fetchOptions?: RequestOptions): Promise<MailFilterRule>;
    getMailboxRules(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<Array<MailFilterRule>>;
    getMailboxRulesByClient(mailboxUid: string, client?: string,  __fetchOptions?: RequestOptions): Promise<Array<MailFilterRule>>;
    getMailboxVacation(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<MailFilter.Vacation>;
    /**
     * Get the unread mail messages count of the currently logged in user
     * @returns unread messages count
     */
    getUnreadMessagesCount( __fetchOptions?: RequestOptions): Promise<number>;
    list( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Mailbox>>>;
    listUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    moveMailboxRule(mailboxUid: string, id: number, direction: RuleMoveDirection,  __fetchOptions?: RequestOptions): Promise<void>;
    moveMailboxRuleRelative(mailboxUid: string, id: number, position: RuleMoveRelativePosition, anchorId: number,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Mailbox>>>;
    setDomainFilter(filter?: MailFilter,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxAccessControlList(mailboxUid: string, accessControlEntries?: Array<AccessControlEntry>,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxDelegationRule(mailboxUid: string, delegationRule?: DelegationRule,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxFilter(mailboxUid: string, filter?: MailFilter,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxForwarding(mailboxUid: string, forwarding?: MailFilter.Forwarding,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxVacation(mailboxUid: string, vacation?: MailFilter.Vacation,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modifies an existing {@link Mailbox} entry.
     * @param uid uid of the entry
     * @param mailbox value of the entry
     */
    update(uid: string, mailbox?: Mailbox,  __fetchOptions?: RequestOptions): Promise<void>;
    updateDomainRule(id: number, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<void>;
    updateMailboxRule(mailboxUid: string, id: number, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class MailboxesClient extends ApiEndPoint implements IMailboxes {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    addDomainRule(rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<number>;
    addMailboxRule(mailboxUid: string, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<number>;
    addMailboxRuleRelative(mailboxUid: string, position: RuleMoveRelativePosition, anchorId: number, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<number>;
    byEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailbox>>;
    byName(name?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailbox>>;
    byRouting(email?: Mailbox.Routing,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    create(uid: string, mailbox?: Mailbox,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteDomainRule(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteMailboxRule(mailboxUid: string, id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailbox>>;
    getDomainFilter( __fetchOptions?: RequestOptions): Promise<MailFilter>;
    getDomainRule(id: number,  __fetchOptions?: RequestOptions): Promise<MailFilterRule>;
    getDomainRules( __fetchOptions?: RequestOptions): Promise<Array<MailFilterRule>>;
    getMailboxAccessControlList(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<Array<AccessControlEntry>>;
    getMailboxConfig(uid: string,  __fetchOptions?: RequestOptions): Promise<MailboxConfig>;
    getMailboxDelegationRule(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<DelegationRule>;
    getMailboxFilter(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<MailFilter>;
    getMailboxForwarding(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<MailFilter.Forwarding>;
    getMailboxQuota(uid: string,  __fetchOptions?: RequestOptions): Promise<MailboxQuota>;
    getMailboxRule(mailboxUid: string, id: number,  __fetchOptions?: RequestOptions): Promise<MailFilterRule>;
    getMailboxRules(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<Array<MailFilterRule>>;
    getMailboxRulesByClient(mailboxUid: string, client?: string,  __fetchOptions?: RequestOptions): Promise<Array<MailFilterRule>>;
    getMailboxVacation(mailboxUid: string,  __fetchOptions?: RequestOptions): Promise<MailFilter.Vacation>;
    getUnreadMessagesCount( __fetchOptions?: RequestOptions): Promise<number>;
    list( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Mailbox>>>;
    listUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    moveMailboxRule(mailboxUid: string, id: number, direction: RuleMoveDirection,  __fetchOptions?: RequestOptions): Promise<void>;
    moveMailboxRuleRelative(mailboxUid: string, id: number, position: RuleMoveRelativePosition, anchorId: number,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Mailbox>>>;
    setDomainFilter(filter?: MailFilter,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxAccessControlList(mailboxUid: string, accessControlEntries?: Array<AccessControlEntry>,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxDelegationRule(mailboxUid: string, delegationRule?: DelegationRule,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxFilter(mailboxUid: string, filter?: MailFilter,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxForwarding(mailboxUid: string, forwarding?: MailFilter.Forwarding,  __fetchOptions?: RequestOptions): Promise<void>;
    setMailboxVacation(mailboxUid: string, vacation?: MailFilter.Vacation,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, mailbox?: Mailbox,  __fetchOptions?: RequestOptions): Promise<void>;
    updateDomainRule(id: number, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<void>;
    updateMailboxRule(mailboxUid: string, id: number, rule?: MailFilterRule,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
