
import { 
    AttachedFile
} from "@bluemind/attachment.api";
import { 
    TagRef
} from "@bluemind/tag.api";
import { 
    BmDateTime
} from "@bluemind/core.foldershare.api";
export type ICalendarElement = {
    dtstart?: BmDateTime;
    summary?: string;
    classification?: ICalendarElement.Classification;
    location?: string;
    /**
     * Contains HTML without the outer html & body markups.
     */
    description?: string;
    priority?: number;
    alarm?: Array<ICalendarElement.VAlarm>;
    status?: ICalendarElement.Status;
    attendees?: Array<ICalendarElement.Attendee>;
    organizer?: ICalendarElement.Organizer;
    categories?: Array<TagRef>;
    exdate?: Array<BmDateTime>;
    rdate?: Array<BmDateTime>;
    rrule?: ICalendarElement.RRule;
    url?: string;
    conference?: string;
    conferenceId?: string;
    conferenceConfiguration?: Record<string, string>;
    attachments?: Array<AttachedFile>;
    properties?: Record<string, string>;
    /**
     * When a ICalendarElement is created, its sequence number is 0. It is
     * monotonically incremented by the "Organizer's" each time the "Organizer"
     * makes a significant revision to the calendar component.
     */
    sequence?: number;
    /**
     * Indicates whether invitations have been already sent at least once.
     */
    draft?: boolean;
};
export namespace ICalendarElement {
    /**
     * 
     */
    export type Organizer = {
        uri?: string;
        commonName?: string;
        mailto?: string;
        dir?: string;
    };
    export type Status =  "NeedsAction" |  "Completed" |  "InProcess" |  "Cancelled" |  "Confirmed" |  "Tentative";
    export const Status : {
        readonly NeedsAction: Status,
        readonly Completed: Status,
        readonly InProcess: Status,
        readonly Cancelled: Status,
        readonly Confirmed: Status,
        readonly Tentative: Status
    };
    export type Attendee = {
        /**
         * "CUTYPE", to indicate the type of calendar user
         */
        cutype?: ICalendarElement.CUType;
        /**
         * "MEMBER", to indicate the groups that the attendee belongs to
         */
        member?: string;
        /**
         * "ROLE", for the intended role that the attendee will have in the calendar
         * component;
         */
        role?: ICalendarElement.Role;
        /**
         * "PARTSTAT", for the status of the attendee's participation;
         */
        partStatus?: ICalendarElement.ParticipationStatus;
        /**
         * "RSVP", for indicating whether the favor of a reply is requested;
         */
        rsvp?: boolean;
        /**
         * "DELEGATED-TO", to indicate the calendar users that the original request was
         * delegated to;
         */
        delTo?: string;
        /**
         * "DELEGATED-FROM", to indicate whom the request was delegated from
         */
        delFrom?: string;
        sentBy?: string;
        commonName?: string;
        /**
         * "DIR", to indicate the URI that points to the directory information
         * corresponding to the attendee.
         */
        dir?: string;
        lang?: string;
        mailto?: string;
        uri?: string;
        internal?: boolean;
        /**
         * Comment by attendee
         */
        responseComment?: string;
        counter?: BmDateTime;
    };
    export type RRule = {
        /**
         * required *
         */
        frequency?: ICalendarElement.RRule.Frequency;
        /**
         * count and until must not occur in the same recur *
         */
        count?: number;
        until?: BmDateTime;
        interval?: number;
        bySecond?: Array<number>;
        byMinute?: Array<number>;
        byHour?: Array<number>;
        byDay?: Array<ICalendarElement.RRule.WeekDay>;
        byMonthDay?: Array<number>;
        byYearDay?: Array<number>;
        byWeekNo?: Array<number>;
        byMonth?: Array<number>;
        bySetPos?: Array<number>;
    };
    export namespace RRule {
        export type WeekDay = {
            day?: string;
            offset?: number;
        };
        export type Frequency =  "SECONDLY" |  "MINUTELY" |  "HOURLY" |  "DAILY" |  "WEEKLY" |  "MONTHLY" |  "YEARLY";
        export const Frequency : {
            readonly SECONDLY: Frequency,
            readonly MINUTELY: Frequency,
            readonly HOURLY: Frequency,
            readonly DAILY: Frequency,
            readonly WEEKLY: Frequency,
            readonly MONTHLY: Frequency,
            readonly YEARLY: Frequency
        };

    }
    /**
     * 4.2.3 Calendar User Type
     *
     * To specify the type of calendar user
     */
    export type CUType =  "Individual" |  "Group" |  "Resource" |  "Room" |  "Unknown";
    export const CUType : {
        /**
         * An individual *
         */
        readonly Individual: CUType,
        /**
         * A group of individual *
         */
        readonly Group: CUType,
        /**
         * A physical Resource *
         */
        readonly Resource: CUType,
        /**
         * A room resource *
         */
        readonly Room: CUType,
        /**
         * Otherwise not known *
         */
        readonly Unknown: CUType
    };
    export type Classification =  "Public" |  "Private" |  "Confidential";
    export const Classification : {
        readonly Public: Classification,
        readonly Private: Classification,
        readonly Confidential: Classification
    };
    export type Role =  "Chair" |  "RequiredParticipant" |  "OptionalParticipant" |  "NonParticipant";
    export const Role : {
        /**
         * Indicates chair of the calendar entity *
         */
        readonly Chair: Role,
        /**
         * Indicates a participant whose participation is required *
         */
        readonly RequiredParticipant: Role,
        /**
         * Indicates a participant whose participation is optional
         */
        readonly OptionalParticipant: Role,
        /**
         * Indicates a participant who is copied for information purposes only
         */
        readonly NonParticipant: Role
    };
    export type VAlarm = {
        action?: ICalendarElement.VAlarm.Action;
        /**
         * Relative to ICalendarelement.dtstart. In SECOND
         *
         * Either a positive or negative duration may be specified for the "TRIGGER"
         * property. An alarm with a positive duration is triggered after the associated
         * start or end of the event or to-do. An alarm with a negative duration is
         * triggered before the associated start or end of the event or to-do.
         */
        trigger?: number;
        description?: string;
        /**
         * in SECOND
         */
        duration?: number;
        repeat?: number;
        summary?: string;
    };
    export namespace VAlarm {
        export type Action =  "Audio" |  "Display" |  "Email";
        export const Action : {
            readonly Audio: Action,
            readonly Display: Action,
            readonly Email: Action
        };

    }
    export type ParticipationStatus =  "NeedsAction" |  "Accepted" |  "Declined" |  "Tentative" |  "Delegated" |  "Completed";
    export const ParticipationStatus : {
        /**
         * To-do needs action *
         */
        readonly NeedsAction: ParticipationStatus,
        /**
         * To-do accepted *
         */
        readonly Accepted: ParticipationStatus,
        /**
         * To-do declined *
         */
        readonly Declined: ParticipationStatus,
        /**
         * To-do tentatively accepted *
         */
        readonly Tentative: ParticipationStatus,
        /**
         * To-do delegated *
         */
        readonly Delegated: ParticipationStatus,
        /**
         * To-do completed *
         */
        readonly Completed: ParticipationStatus
    };

}
