import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './GroupClient.json';

export class GroupClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/groups/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async add(uid, members,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/members';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (members != null) {
            __options.body = JSON.stringify(members);
        }
		return this.__fetchVoid(__url, __options);
    }
    async allUids( __fetchOptions = {}) {
        let __path = this.base + '/_alluids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/byEmail/{email}';
        __path = __path.replace('{email}', encodeURIComponent(email));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byName(name,  __fetchOptions = {}) {
        let __path = this.base + '/byName/{name}';
        __path = __path.replace('{name}', encodeURIComponent(name));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async create(uid, group,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (group != null) {
            __options.body = JSON.stringify(group);
        }
		return this.__fetchVoid(__url, __options);
    }
    async createWithExtId(uid, extid, group,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/{extid}/createwithextid';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{extid}', encodeURIComponent(extid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (group != null) {
            __options.body = JSON.stringify(group);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async get(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (uid != null) {
            __options.body = JSON.stringify(uid);
        }
		return this.__fetchContent(__url, __options);
    }
    async getByExtId(extid,  __fetchOptions = {}) {
        let __path = this.base + '/_extid/{extid}';
        __path = __path.replace('{extid}', encodeURIComponent(extid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getExpandedMembers(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/expandedmembers';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getExpandedUserMembers(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/expandedusersmembers';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getGroupsWithRoles(roles,  __fetchOptions = {}) {
        let __path = this.base + '/_rolegroups';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (roles != null) {
            __options.body = JSON.stringify(roles);
        }
		return this.__fetchContent(__url, __options);
    }
    async getLight(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/light';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMembers(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/members';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getParents(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/parents';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRoles(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/roles';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async memberOf(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/groups';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async memberOfGroups(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/groupUids';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async remove(uid, members,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/members';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (members != null) {
            __options.body = JSON.stringify(members);
        }
		return this.__fetchVoid(__url, __options);
    }
    async search(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async setExtId(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_extId';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setRoles(uid, roles,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/roles';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (roles != null) {
            __options.body = JSON.stringify(roles);
        }
		return this.__fetchVoid(__url, __options);
    }
    async touch(uid, update_vcards,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_touch';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (update_vcards != null) {
            __url.searchParams.append("update_vcards", update_vcards);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, group,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (group != null) {
            __options.body = JSON.stringify(group);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
