import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './FileHostingClient.json';

export class FileHostingClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/filehosting/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async delete(path,  __fetchOptions = {}) {
        let __path = this.base + '/{path}';
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async exists(path,  __fetchOptions = {}) {
        let __path = this.base + '/{path}/_exists';
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async find(query,  __fetchOptions = {}) {
        let __path = this.base + '/_find';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (query != null) {
            __url.searchParams.append("query", query);
        }
		return this.__fetchContent(__url, __options);
    }
    async get(path,  __fetchOptions = {}) {
        let __path = this.base + '/{path}/_content';
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        return this.__fetchBlob(__url, __options);
    }
    async getConfiguration( __fetchOptions = {}) {
        let __path = this.base + '/_config';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async info( __fetchOptions = {}) {
        let __path = this.base + '/_info';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async list(path,  __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (path != null) {
            __url.searchParams.append("path", path);
        }
		return this.__fetchContent(__url, __options);
    }
    async share(path, downloadLimit, expirationDate,  __fetchOptions = {}) {
        let __path = this.base + '/_share';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (path != null) {
            __url.searchParams.append("path", path);
        }
        if (downloadLimit != null) {
            __url.searchParams.append("downloadLimit", downloadLimit);
        }
        if (expirationDate != null) {
            __url.searchParams.append("expirationDate", expirationDate);
        }
		return this.__fetchContent(__url, __options);
    }
    async store(path, document,  __fetchOptions = {}) {
        let __path = this.base + '/{path}';
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (document != null) {
            __options.body = document;
        }
		return this.__fetchVoid(__url, __options);
    }
    async storeAndShare(path, downloadLimit, expirationDate, document,  __fetchOptions = {}) {
        let __path = this.base + '/_store_share';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (path != null) {
            __url.searchParams.append("path", path);
        }
        if (downloadLimit != null) {
            __url.searchParams.append("downloadLimit", downloadLimit);
        }
        if (expirationDate != null) {
            __url.searchParams.append("expirationDate", expirationDate);
        }
        if (document != null) {
            __options.body = document;
        }
		return this.__fetchContent(__url, __options);
    }
    async unShare(url,  __fetchOptions = {}) {
        let __path = this.base + '/{url}/unshare';
        __path = __path.replace('{url}', encodeURIComponent(url));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
