import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DocumentClient.json';

export class DocumentClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, containerUid , itemUid , base = '') {
        super(apiKey, base + '/api/document/{containerUid}/{itemUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
        this.itemUid = itemUid;
        this.base = this.base.replace('{itemUid}', encodeURIComponent(itemUid));
    }
    async create(uid, doc,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (doc != null) {
            __options.body = JSON.stringify(doc);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async fetch(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async fetchMetadata(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/metadata';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async list( __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async update(uid, doc,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (doc != null) {
            __options.body = JSON.stringify(doc);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
