
import { OrgUnit } from "./OrgUnit"; 
import { OrgUnitQuery } from "./OrgUnitQuery"; 
import { OrgUnitPath } from "./OrgUnitPath"; 
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Manages Organizational Units
 * 
 * BlueMind integrates a delegated administration functionality. It allows you
 * to grant limited administration rights to administrators (who become
 * delegated administrators). Delegated administration rights can be given to
 * specific users selected according to certain criteria (job type, industry,
 * geographical area...). The resulting group is called an {@link OrgUnit}
 */
export interface IOrgUnits {
    /**
     * Create an {@link OrgUnit}
     * @param uid Unique ID of the new {@link OrgUnit}
     * @param value {@link OrgUnit}
     */
    create(uid: string, value?: OrgUnit,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete an {@link OrgUnit}
     * @param uid UID of the {@link OrgUnit}
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Get the roles of a member or the {@link net.bluemind.group.api.Group}s he is
     * member of
     * @param groups UIDs of the {@link net.bluemind.group.api.Group}s the
     *                    {@link DirEntry} is member of
     * @returns Set of roles
     */
    getAdministratorRoles(uid: string, dirUid: string, groups?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Get the UIDs of an {@link OrgUnit}'s administrators
     * @param uid {@link OrgUnit} UID
     * @returns Set of UIDs
     */
    getAdministrators(uid: string, hierarchical?: boolean,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Get all child elements of an {@link OrgUnit}
     * @param uid {@link OrgUnit} UID
     * @returns {@link net.bluemind.core.container.model.ItemValue}s containing the
     *         {@link OrgUnit}s
     */
    getChildren(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<OrgUnit>>>;
    /**
     * Get {@link OrgUnit} by UID
     * @param uid UID
     * @returns {@link net.bluemind.core.container.model.ItemValue} containing the
     *         {@link OrgUnit}, or null if not found
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<OrgUnit>>;
    /**
     * Get {@link OrgUnitPath} by {@link OrgUnit} UID
     * @param uid UID
     * @returns {@link OrgUnitPath} or null, if not found
     */
    getPath(uid: string,  __fetchOptions?: RequestOptions): Promise<OrgUnitPath>;
    /**
     * Get a list of {@link OrgUnitPath}s by the UID of an administrator or the
     * {@link net.bluemind.group.api.Group}s he is member of
     * @param administrator Administrator UID
     * @param groups UIDs of the {@link net.bluemind.group.api.Group}s the
     *                      {@link DirEntry} is member of
     * @returns List of {@link OrgUnitPath}s
     */
    listByAdministrator(administrator?: string, groups?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<OrgUnitPath>>;
    /**
     * Remove an administrator from an {@link OrgUnit}
     * @param administrator Administrator UID
     */
    removeAdministrator(administrator?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Get a list of {@link OrgUnitPath}s by {@link OrgUnitQuery}
     * @param query {@link OrgUnitQuery}
     * @returns List of matching {@link OrgUnitPath}s
     */
    search(query?: OrgUnitQuery,  __fetchOptions?: RequestOptions): Promise<Array<OrgUnitPath>>;
    /**
     * Grant roles to a member of an {@link OrgUnit}
     * @param roles Set of roles
     */
    setAdministratorRoles(uid: string, dirUid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update an {@link OrgUnit}
     * @param uid UID of the {@link OrgUnit}
     * @param value {@link OrgUnit}
     */
    update(uid: string, value?: OrgUnit,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class OrgUnitsClient extends ApiEndPoint implements IOrgUnits {
    domain: string;
    constructor(apiKey: string, domain: string, base?: string);
    create(uid: string, value?: OrgUnit,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getAdministratorRoles(uid: string, dirUid: string, groups?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getAdministrators(uid: string, hierarchical?: boolean,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getChildren(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<OrgUnit>>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<OrgUnit>>;
    getPath(uid: string,  __fetchOptions?: RequestOptions): Promise<OrgUnitPath>;
    listByAdministrator(administrator?: string, groups?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<OrgUnitPath>>;
    removeAdministrator(administrator?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    search(query?: OrgUnitQuery,  __fetchOptions?: RequestOptions): Promise<Array<OrgUnitPath>>;
    setAdministratorRoles(uid: string, dirUid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, value?: OrgUnit,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
